/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.PostDeserialize;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.PostSerialize;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.PreSerialize;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.gson.HookInvocationException;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.util.reflection.AbstractMethodInspector;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.util.reflection.MethodInvoker;

public final class HooksInvoker {
    private static final Set<Class> SUPPORTED_TYPES = new HashSet<Class>(Arrays.asList(JsonElement.class, Gson.class));
    private AbstractMethodInspector<MethodInvoker> inspector = new AbstractMethodInspector<MethodInvoker>(){

        @Override
        protected MethodInvoker map(Method member) {
            return new MethodInvoker(member, SUPPORTED_TYPES);
        }
    };

    public void preSerialize(Object obj) {
        this.invokeAll(obj, PreSerialize.class, null, null);
    }

    public void postSerialize(Object obj, JsonElement jsonElement, Gson gson) {
        this.invokeAll(obj, PostSerialize.class, jsonElement, gson);
    }

    public void postDeserialize(Object obj, JsonElement jsonElement, Gson gson) {
        this.invokeAll(obj, PostDeserialize.class, jsonElement, gson);
    }

    private void invokeAll(Object obj, Class<? extends Annotation> annotation, JsonElement jsonElement, Gson gson) {
        if (obj != null) {
            for (MethodInvoker m : this.inspector.getAnnotatedMembers(obj.getClass(), annotation)) {
                try {
                    m.invoke(obj, new HooksInvokerValueSupplier(jsonElement, gson));
                }
                catch (IllegalAccessException e) {
                    throw new HookInvocationException("Exception during hook invocation: " + annotation.getSimpleName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new HookInvocationException("Exception during hook invocation: " + annotation.getSimpleName(), e.getTargetException());
                }
            }
        }
    }

    private static class HooksInvokerValueSupplier
    implements MethodInvoker.ValueSupplier {
        private final JsonElement jsonElement;
        private final Gson gson;

        private HooksInvokerValueSupplier(JsonElement jsonElement, Gson gson) {
            this.jsonElement = jsonElement;
            this.gson = gson;
        }

        @Override
        public Object getValueForType(Class type) {
            if (type == JsonElement.class) {
                return this.jsonElement;
            }
            if (type == Gson.class) {
                return this.gson;
            }
            return null;
        }
    }
}

